% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.inputs.R
\name{update_params}
\alias{update_params}
\title{Update Model Parameters for Stochastic Network Models}
\usage{
update_params(param, new.param.list)
}
\arguments{
\item{param}{Object of class \code{param.net}, output from function of same
name.}

\item{new.param.list}{Named list of new parameters to add to original
parameters.}
}
\value{
An updated list object of class \code{param.net}, which can be passed to the
EpiModel function \code{\link{netsim}}.
}
\description{
Updates epidemic model parameters originally set with
\code{\link{param.net}} and adds new parameters.
}
\details{
This function can update any original parameters specified with
\code{\link{param.net}} and add new parameters. This function would be used
if the inputs to \code{\link{param.net}} were a long list of fixed model
parameters that needed supplemental replacements or additions for particular
model runs (e.g., changing an intervention efficacy parameter but leaving all
other parameters fixed).

The \code{new.param.list} object should be a named list object containing
named parameters matching those already in \code{x} (in which case those
original parameter values will be replaced) or not matching (in which case
new parameters will be added to \code{param}).
}
\examples{
x <- param.net(inf.prob = 0.5, act.rate = 2)
y <- list(inf.prob = 0.75, dx.rate = 0.2)
z <- update_params(x, y)
print(z)

}
