% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.icm}
\alias{summary.icm}
\title{Summary Model Statistics}
\usage{
\method{summary}{icm}(object, at, digits = 3, ...)
}
\arguments{
\item{object}{An \code{EpiModel} object of class \code{icm}.}

\item{at}{Time step for model statistics.}

\item{digits}{Number of significant digits to print.}

\item{...}{Additional summary function arguments.}
}
\description{
Extracts and prints model statistics simulated with \code{icm}.
}
\details{
Summary statistics for the main epidemiological outcomes (state and
transition size and prevalence) from an \code{icm} model. Time-specific
summary measures are provided, so it is necessary to input a time of
interest.
}
\examples{
## Stochastic ICM SI model with 3 simulations
param <- param.icm(inf.prob = 0.2, act.rate = 1)
init <- init.icm(s.num = 500, i.num = 1)
control <- control.icm(type = "SI", nsteps = 50,
                       nsims = 5, verbose = FALSE)
mod <- icm(param, init, control)
summary(mod, at = 25)
summary(mod, at = 50)

}
\seealso{
\code{\link{icm}}
}
\keyword{extract}
