% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.record.R
\name{record_attr_history}
\alias{record_attr_history}
\title{Record Attributes History}
\usage{
record_attr_history(dat, at, attribute, posit_ids, values)
}
\arguments{
\item{dat}{a Master list object of network models}

\item{at}{the time where the recording happens}

\item{attribute}{the name of the value to record}

\item{posit_ids}{a numeric vector of posit_ids to which the measure applies.
(see \code{get_posit_ids})}

\item{values}{the values to be recorded}
}
\value{
The Master list object


See the "Time Varying Attributes" vignette
}
\description{
This function records values specific to a time-step and a group of nodes.
The nodes are identified by their \code{unique_ids} which allows the
recording of data for nodes that are no longer in the network by the end of
the run. The records are stored in \code{dat[["attr.history"]]} and can be
accessed from the \code{netsim} object with \code{get_attr_history}
}
\examples{
\dontrun{

dat <- record_attr_history(dat, at, "attr_1", get_posit_ids(dat), 5)
some_nodes <- get_posit_ids(dat)
some_nodes <- some_nodes[runif(length(some_nodes)) < 0.2]
dat <- record_attr_history(
  dat, at,
  "attr_2",
  some_nodes,
  rnorm(length(some_nodes))
)

}

}
