% Generated by roxygen2 (4.0.1): do not edit by hand
\name{param.icm}
\alias{param.icm}
\title{Epidemic Parameters for Stochastic Individual Contact Models}
\usage{
param.icm(trans.rate, act.rate, rec.rate, b.rate, ds.rate, di.rate, dr.rate,
  trans.rate.g2, act.rate.g2, rec.rate.g2, b.rate.g2, ds.rate.g2, di.rate.g2,
  dr.rate.g2, balance, ...)
}
\arguments{
\item{trans.rate}{probability of transmission given a transmissible act between
a susceptible and an infected person. In two-group models, this is the
probability of transmission to the group 1 members.}

\item{act.rate}{average number of transmissible acts per person per unit time.
For two-group models, this is the number of acts per group 1 persons
per unit time; a balance between the acts in groups 1 and 2 is necessary,
and set using the \code{balance} parameter (see details).}

\item{rec.rate}{average rate of recovery with immunity (in \code{SIR} models)
or re-susceptibility (in \code{SIS} models). The recovery rate is the
reciprocal of the disease duration. For two-group models, this is the
recovery rate for group 1 persons only. This parameter is only used for
\code{SIR} and \code{SIS} models.}

\item{b.rate}{birth or entry rate. For one-group models, the birth rate is the
rate of new births per person per unit time. For two-group models, the
birth rate may be parameterized as a rate per group 1 person time (with
group 1 persons representing females), and with the \code{b.rate.g2}
rate set as described below.}

\item{ds.rate}{death or exit rate for susceptibles. For two-group models, it
is the rate for the group 1 susceptibles only.}

\item{di.rate}{death or exit rate for infecteds. For two-group models, it is
the rate for the group 1 infecteds only.}

\item{dr.rate}{death or exit rate for recovereds. For two-group models, it is
the rate for the group 1 recovered only. This parameter is only used for
\code{SIR} models.}

\item{trans.rate.g2}{probability of transmission given a transmissible act
between a susceptible group 2 person and an infected group 1 person.
It is the probability of transmission to group 2 members.}

\item{act.rate.g2}{average number of transmissible acts per group 2 person per
unit time; a balance between the acts in groups 1 and 2 is necessary,
and set using the \code{balance} parameter (see details).}

\item{rec.rate.g2}{average rate of recovery with immunity (in \code{SIR} models)
or re-susceptibility (in \code{SIS} models) for group 2 persons. This
parameter is only used for two-group \code{SIR} and \code{SIS} models.}

\item{b.rate.g2}{birth or entry rate for group 2. This may either be specified
numerically as the rate of new births per group 2 persons per unit time,
or as \code{NA} in which case the group 1 rate, \code{b.rate}, governs
the group 2 rate. The latter is used when, for example, the first group
is conceptualized as female, and the female population size determines
the birth rate. Such births are evenly allocated between the two groups.}

\item{ds.rate.g2}{death or exit rate for group 2 susceptibles.}

\item{di.rate.g2}{death or exit rate for group 2 infecteds.}

\item{dr.rate.g2}{death or exit rate for group 2 recovereds. This parameter is
only used for \code{SIR} model types.}

\item{balance}{for two-group models, balance the \code{act.rate} to the rate
set for group 1 (with \code{balance="g1"}) or group 2 (with
\code{balance="g2"}). See details.}

\item{...}{additional arguments passed to model.}
}
\description{
Sets the epidemic parameters for stochastic individual contact
             models simulated with \code{icm}.
}
\details{
\code{param.icm} sets the epidemic parameters for the stochastic individual
contact models simulated with the \code{\link{icm}} function. Models
may use the built-in types, for which these parameters are used, or new process
modules which may use these parameters (but not necessarily). A detailed
description of ICM parameterization for built-in models is found in Section 3
of the \href{http://statnet.org/EpiModel/vignette/Tutorial.pdf}{EpiModel
Tutorial}.

For built-in models, the model specification will be chosen as a result of
the model parameters entered here and the control settings in
\code{\link{control.icm}}. One-group and two-group models are available, where
the former assumes a homogenous mixing in the population whereas the latter
assumes a purely heterogenous mixing between two distinct partitions in the
population (e.g., men and women). Specifying any group two parameters (those
with a \code{.g2}) implies the simulation of a two-group model. All the
parameters for a desired model type must be specified, even if they are zero.
}
\section{Act Balancing}{

In two-group models, a balance between the number of acts for group 1 members
and those for group 2 members must be maintained. With purely heterogenous
mixing, the product of one group size and act rate must equal the product of
the other group size and act rate: \eqn{N_1 \alpha_1 = N_2 \alpha_2}, where
\eqn{N_i} is the group size and \eqn{\alpha_i} the group-specific act rates
at time \eqn{t}. The \code{balance} parameter here specifies which group's
act rate should control the others with respect to balancing. See the
\href{http://statnet.org/EpiModel/vignette/Tutorial.pdf}{EpiModel Tutorial}
for further details.
}

\section{New Modules}{

To build original models outside of the built-in models, new process modules
may be constructed to replace the existing modules or to supplement the existing
set. These are passed into the control settings in \code{\link{control.icm}}.
New modules may use either the existing model parameters named here, an
original set of parameters, or a combination of both. The \code{...} allows
the user to pass an arbitrary set of original model parmeters into
\code{param.icm}. Whereas there are strict checks with default modules for
parameter validity, these checks are the user's responsibility with new modules.
}
\seealso{
Use \code{\link{init.icm}} to specify the initial conditions and
         \code{\link{control.icm}} to specify the control settings. Run the
         parameterized model with \code{\link{icm}}.
}
\keyword{parameterization}

