% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/utils_mumhtargetdist.R
\name{utils_mumhtargetdist}
\alias{utils_mumhtargetdist}
\title{Target Distribution for MH Step for \code{mu}}
\usage{
utils_mumhtargetdist(mumh, psi, pi, z.pi, muparm)
}
\arguments{
\item{mumh}{The proposed or old value of \code{mu}.}

\item{psi}{The current MCMC iteration's value for \code{psi} (related to the variability
of the disease prevalences among infected clusters of subjects).}

\item{pi}{The current MCMC iteration's value for \code{pi} (the subject-level
prevalences in each cluster).}

\item{z.pi}{The current MCMC iteration's value for \code{z.pi} (the indicator variables
corresponding to the disease status of each cluster).}

\item{muparm}{The old first and second shape parameters.}
}
\value{
A realization from the target distribution.
}
\description{
This function caculates realizations from the target distribution for \code{mu} in
    the Metropolis-Hastings (MH) step in the hybrid Gibbs sampler used in the
    \code{\link{EpiBayes_ns}} and \code{\link{EpiBayes_s}} functions. Recall,
    in the context of disease freedom, \code{mu} was the average disease prevalence
    in a given diseased cluster of subjects.
}
\references{
Norets, A. and Tang, X. \emph{MCMC estimation of a finite beta mixture}. Technical
    report, Princeton University, 2010.
}
\seealso{
Used in the functions \code{\link{EpiBayes_ns}} and \code{\link{EpiBayes_s}}.
}

