% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read}
\alias{read}
\title{Read NetCDF data from global inventories}
\source{
Read abbout EDGAR at http://edgar.jrc.ec.europa.eu and MACCITY at
http://accent.aero.jussieu.fr/MACC_metadata.php
}
\usage{
read(
  file = file.choose(),
  version = NA,
  coef = rep(1, length(file)),
  spec = NULL,
  year = 1,
  month = 1,
  hour = 1,
  categories,
  reproject = TRUE,
  as_raster = TRUE,
  skip_missing = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{file}{file name or names (variables are summed)}

\item{version}{Character; One of  of the following:
\tabular{lllll}{
  \strong{argument}\tab \strong{tested}\tab \strong{region}\tab \strong{resolution}\tab \strong{projection}\cr
  EDGAR\tab 4.32 and 5.0 \tab Global \tab 0.1 x 0.1 ° \tab  longlat\cr
  EDGAR_HTAPv2\tab 2.2 \tab Global \tab 0.1 x 0.1 °  \tab  longlat\cr
  GAINS\tab v5a \tab Global \tab 0.5 x 0.5 ° \tab  longlat\cr
  RCP\tab RCP3PD Glb \tab Global \tab 0.5 x 0.5 °  \tab  longlat\cr
  MACCITY\tab 2010 \tab Global \tab 0.5 x 0.5 °  \tab  longlat\cr
  FFDAS\tab 2.2 \tab Global \tab 0.1 x 0.1 ° \tab  longlat\cr
  ODIAC\tab 2020 \tab Global \tab 1 x 1 ° \tab  longlat\cr
  VULCAN-y\tab 3.0 \tab US \tab 1 x 1 Km \tab  lcc\cr
  VULCAN-h\tab 3.0 \tab US \tab 1 x 1 Km \tab  lcc\cr
  ACES\tab 2020 \tab NE US \tab 1 x 1 km \tab  lcc\cr
}}

\item{coef}{coefficients to merge different sources (file) into one emission}

\item{spec}{numeric speciation vector to split emission into different species}

\item{year}{scenario index (only for GAINS and VULCAN-y)}

\item{month}{the desired month of the inventory (MACCITY and ODIAC)}

\item{hour}{hour of the emission (only for ACES and VULCAN-h)}

\item{categories}{considered categories (for MACCITY/GAINS variable names), empty for use all}

\item{reproject}{to project the output to "+proj=longlat" needed for emission function (only for VULCAN and ACES)}

\item{as_raster}{return a raster (default) or matrix (with units)}

\item{skip_missing}{return a zero emission and a warning for missing files/variables}

\item{verbose}{display additional information}
}
\value{
Matrix or raster
}
\description{
Read data from global inventories. Several files can be read to produce one
emission output and/or can be splitted into several species
}
\note{
for EDGAR (all versions), GAINS, RCP and MACCTITY, please use flux (kg m-2 s-1) NetCDF file.
}
\examples{
\donttest{
dir.create(file.path(tempdir(), "EDGARv432"))
folder <- setwd(file.path(tempdir(), "EDGARv432"))

url <- "http://jeodpp.jrc.ec.europa.eu/ftp/jrc-opendata/EDGAR/datasets/v432_AP/NOx"
file <- 'v432_NOx_2012.0.1x0.1.zip'

download.file(paste0(url,'/TOTALS/',file), file)

unzip('v432_NOx_2012.0.1x0.1.zip')

nox  <- read(file    = dir(pattern = '.nc'),
             version = 'EDGAR',
             spec    = c(E_NO  = 0.9 ,   # 90\% of NOx is NO
                         E_NO2 = 0.1 ))  # 10\% of NOx is NO2
setwd(folder)

sp::spplot(nox$E_NO, scales = list(draw=TRUE),
           xlab="Lat", ylab="Lon",
           main="NO emissions from EDGAR (in g / m2 s)")

d1  <- gridInfo(paste(system.file("extdata", package = "EmissV"),"/wrfinput_d01",sep=""))
NO  <- emission(grid = d1, inventory = nox$E_NO, pol = "NO", mm = 30.01, plot = TRUE)
}
}
\references{
Janssens-Maenhout, G., Dentener, F., Van Aardenne, J., Monni, S., Pagliari, V., Orlandini,
L., ... & Wankmüller, R. (2012). EDGAR-HTAP: a harmonized gridded air pollution emission dataset
based on national inventories. European Commission Joint Research Centre Institute for
Environment and Sustainability. JRC 68434 UR 25229 EUR 25229, ISBN 978-92-79-23123-0.

Lamarque, J.-F., Bond, T. C., Eyring, V., Granier, C., Heil, A., Klimont, Z., Lee, D., Liousse,
C., Mieville, A., Owen, B., Schultz, M. G., Shindell, D., Smith, S. J., Stehfest, E.,
Van Aardenne, J., Cooper, O. R., Kainuma, M., Mahowald, N., McConnell, J. R., Naik, V.,
Riahi, K., and van Vuuren, D. P.: Historical (1850-2000) gridded anthropogenic and biomass
burning emissions of reactive gases and aerosols: methodology and application,
Atmos. Chem. Phys., 10, 7017-7039, doi:10.5194/acp-10-7017-2010, 2010.

Z Klimont, S. J. Smith and J Cofala The last decade of global anthropogenic sulfur dioxide:
2000–2011 emissions Environmental Research Letters 8, 014003, 2013

Gurney, Kevin R., Jianming Liang, Risa Patarasuk, Yang Song, Jianhua Huang, and
Geoffrey Roest (2019) The Vulcan Version 3.0 High-Resolution Fossil Fuel CO2 Emissions
for the United States. Nature Scientific Data.
}
\seealso{
\code{\link{rasterSource}} and \code{\link{gridInfo}}

\code{\link{species}}
}
