% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pointSource.R
\name{pointSource}
\alias{pointSource}
\title{Emissions from point sources}
\usage{
pointSource(emissions, grid, verbose = TRUE)
}
\arguments{
\item{emissions}{list of points}

\item{grid}{grid object with the grid information}

\item{verbose}{display additional information}
}
\value{
a raster
}
\description{
Transform a set of points into a grinded output
}
\examples{
d1 <- gridInfo(paste(system.file("extdata", package = "EmissV"),"/wrfinput_d01",sep=""))

p = data.frame(lat      = c(-22,-22,-23.5),
               lon      = c(-46,-48,-47  ),
               z        = c(0  ,  0,  0  ),
               emission = c(666,444,111  ) )

p_emissions <- pointSource(emissions = p, grid = d1)
\donttest{
sp::spplot(p_emissions,scales = list(draw=TRUE), ylab="Lat", xlab="Lon",
           main = "3 point sources for domain d1")
}

}
\seealso{
\code{\link{gridInfo}} and \code{\link{rasterSource}}
}
