% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EllCopLikelihood.R
\name{EllCopLikelihood}
\alias{EllCopLikelihood}
\title{Computation of the likelihood of an elliptical copula}
\usage{
EllCopLikelihood(grid, g_d, pointsToCompute, Sigma_m1, log = TRUE)
}
\arguments{
\item{grid}{the discretization grid on which the generator is given.}

\item{g_d}{the values of the \eqn{d}-dimensional density generator on the grid.}

\item{pointsToCompute}{the points \eqn{U} at which the likelihood should be computed.
If \code{pointsToCompute} is a vector, then its length is used as the dimension \eqn{d} of the space.
If it is a matrix, then the dimension of the space is the number of columns.}

\item{Sigma_m1}{the inverse correlation matrix of the elliptical distribution.}

\item{log}{if \code{TRUE}, this returns the log-likelihood instead of the likelihood.}
}
\value{
a vector (of length 1 if \code{pointsToCompute} is a vector) of likelihoods
associated with each observation.
}
\description{
Computes the likelihood
\deqn{\frac{g(Q_g(U) \Sigma^{-1} Q_g(U))}{f_g(Q_g(U_1)) \cdots f_g(Q_g(U_d))}
}{g ( Q_g(U) \Sigma^{-1} Q_g(U) ) / f_g(Q_g(U_1)) ... f_g(Q_g(U_d))}
for a vector \eqn{(U_1, \dots, U_d)} on the unit cube
and for a \eqn{d}-dimensional generator \eqn{g} whose univariate density and quantile functions
are respectively \eqn{f_g} and \eqn{Q_g}.
This is to the likelihood of the copula associated with the elliptical distribution
having density \eqn{|det(\Sigma)|^{-1/2} g(x \Sigma^{-1} x)}.
}
\examples{
grid = seq(0,50,by = 0.01)
gdnorm = DensityGenerator.normalize(grid = grid, grid_g = exp(-grid/2), d = 3)
gdnorm2 = DensityGenerator.normalize(grid = grid, grid_g = 1/(1+grid^2), d = 3)
X = EllCopSim(n = 30, d = 3, grid = grid, g_d = gdnorm)
logLik = EllCopLikelihood(grid , g_d = gdnorm , X,
                          Sigma_m1 = diag(3), log = TRUE)
logLik2 = EllCopLikelihood(grid , g_d = gdnorm2 , X,
                           Sigma_m1 = diag(3), log = TRUE)
print(c(sum(logLik), sum(logLik2)))

}
\references{
Derumigny, A., & Fermanian, J. D. (2022).
Identifiability and estimation of meta-elliptical copula generators.
Journal of Multivariate Analysis, article 104962.
\doi{10.1016/j.jmva.2022.104962}.
}
\seealso{
\code{\link{EllCopEst}} for the estimation of elliptical copula,
\code{\link{EllCopEst}} for the estimation of elliptical copula.
}
