% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EllDistrEst.R
\name{EllDistrEst}
\alias{EllDistrEst}
\title{Nonparametric estimation of the density generator of an elliptical distribution}
\usage{
EllDistrEst(
  X,
  mu = 0,
  Sigma_m1 = diag(d),
  grid,
  h,
  Kernel = "epanechnikov",
  a = 1
)
}
\arguments{
\item{X}{matrix of observations.}

\item{mu}{(estimated) mean of X.}

\item{Sigma_m1}{(estimated) inverse of the covariance matrix of X.}

\item{grid}{grid of values on which to estimate the density generator}

\item{h}{bandwidth of the kernel}

\item{Kernel}{kernel used for the smoothing}

\item{a}{tuning parameter to improve the performance at 0.
See Liebscher (2005), Example p.210}
}
\value{
the values of the density generator of the elliptical copula,
estimated at each point of the \code{grid}.
}
\description{
This function uses Liebscher's algorithm to estimate the density generator
of an elliptical distribution by kernel smoothing.
}
\examples{
# Comparison between the estimated and true generator of the Gaussian distribution
X = matrix(rnorm(5000*3), ncol = 3)
grid = seq(0,5,by=0.01)
g_3 = EllDistrEst(X = X, grid = grid, a = 0.7, h=0.05)
plot(grid, g_3, type = "l")
lines(grid, exp(-grid/2)/(2*pi)^{3/2}, col = "red")

}
\references{
Liebscher, E. (2005).
A semiparametric density estimator based on elliptical distributions.
Journal of Multivariate Analysis, 92(1), 205.
\doi{10.1016/j.jmva.2003.09.007}
}
\seealso{
\code{\link{EllDistrSim}} for the simulation of elliptical distribution samples,
\code{\link{EllCopEst}} for the estimation of elliptical copulas.
}
