% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelar.R
\name{modelar}
\alias{modelar}
\title{Componentes e Testes}
\usage{
modelar(y, dlm, estrutura)
}
\arguments{
\item{y}{Série temporal a ser decomposta}

\item{dlm}{Objeto 'dlm'}

\item{estrutura}{Lista com variáveis importantes para realização de testes:
\itemize{
  \item \code{p}: Número de variâncias estocásticas
  \item \code{logLike}: Valor da função de log-verossimilhança }}
}
\value{
Lista com 15 variáveis, entre componentes e testes:
  \itemize{
    \item \code{y}: Série que foi decomposta.
    \item \code{dlm}: Estrutura do objeto dlm usado na decomposição.
    \item \code{f}: Lista de resultados do Filtro de Kalman. Ver \code{dlmFilter}.
    \item \code{s}: Lista de resultados do processo de suavização. Ver \code{dlmSmooth}.
    \item \code{comp}: Tabela com os componentes de interesses suavizados (Resultado Principal).
    \item \code{interv}: tabela listando as intervenções, seu componente.
    período, valor, desvio padrão do estimador e o pvalor do teste t.
    \item \code{choques}: Matriz dos disturbios suavizados. Ver \code{choques}.
    \item \code{e}: Série dos erros de projeção um passo a frente.
    \item \code{q}: Teste de independência dos erros de projeção.
    \item \code{q2}: Teste de independência dos erros de projeção, com o dobro de lags.
    \item \code{h}: Teste de homocedasticidade dos erros de projeção.
    \item \code{nt}: Teste de normalidade dos erros de projeção.
    \item \code{aic}: Critério de Akaike.
    \item \code{bic}: Critério de Bayes.
    \item \code{tt}: Lista com resultado de testes t para os coeficientes estimados. }
}
\description{
Função que calcula a partir do objeto dlm e de algumas variáveis estruturais,
o valor dos componentes, reestrutura o resultados da função do pacote dlm para fins
de legibilidade, e, por fim, realiza testes diversos nos resíduos e valores obtidos.
}
\keyword{internal}
