% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showWeights.R
\name{showWeights}
\alias{showWeights}
\title{Retrieve Weight Variables}
\usage{
showWeights(data, verbose = FALSE)
}
\arguments{
\item{data}{an \code{edsurvey.data.frame}, a \code{light.edsurvey.data.frame}, or 
an \code{edsurvey.data.frame.list}}

\item{verbose}{a logical value; set to TRUE to print the complete list of jackknife
replicate weights associated with each full sample weight;
otherwise, prints only the full sample weights}
}
\description{
Prints a summary of the weights in an \code{edsurvey.data.frame}, a \code{light.edsurvey.data.frame}, or an \code{edsurvey.data.frame.list}.
}
\examples{
# read in the example data (generated, not real student data)
sdf <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package="NAEPprimer"))

# show the weights
showWeights(sdf, TRUE)
}
\author{
Michael Lee and Paul Bailey
}
