% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clustergram.R
\name{clustergram.plot.matlines}
\alias{clustergram.plot.matlines}
\title{Plot function for clustergram}
\usage{
clustergram.plot.matlines(X, Y, k.range, x.range, y.range, COL,
  add.center.points, centers.points)
}
\arguments{
\item{X}{vector of the k number of cluster for the x-axis}

\item{Y}{corrdinates of the cluster centers on the y-axis}

\item{k.range}{x axis breaks.}

\item{x.range}{x axis range.}

\item{y.range}{y axis range (PCA scores).}

\item{COL}{colour palette.}

\item{add.center.points}{Should the centers be plotted as points. (see
clustergram)}

\item{centers.points}{matrix of centers position.}
}
\value{
A clustergram plot.
}
\description{
Plot function for clustergram
}
\details{
Internal clustergram plot function. The input arguments are computed
  by the clustergram function directly.
}
\examples{
####### Example data:
   SyntheticTrial <- SyntheticData(SpeciesNum = 100,
                                   CommunityNum = 3, SpCo = NULL,
                                   Length = 500,
                                   Parameters = list(a=c(40, 80, 50),
                                                     b=c(100,250,400),
                                                     c=rep(0.03,3)),
                                   dev.c = .015, pal = c("#008585", "#FBF2C4", "#C7522B"))

   ######## 6 clustergram plots
   for (i in 1:6) clustergram(as.matrix(SyntheticTrial[,2:ncol(SyntheticTrial)]),
                              clustering.function = clustergram.kmeans,
                              clustergram.plot = clustergram.plot.matlines,
                              k.range = 2:10, line.width = .2)

}
