% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eco.rasterplot.R
\name{eco.rasterplot}
\alias{eco.rasterplot}
\title{rasterplot graphs}
\usage{
eco.rasterplot(x, filter = NULL, condition = NULL, grp = NULL,
  limits = NULL, title = NULL, z.name = NULL, vertical = TRUE,
  interactivePlot = TRUE, ...)
}
\arguments{
\item{x}{data matrix (raster)}

\item{filter}{optional data matrix used as filter}

\item{condition}{condition used to filter data}

\item{grp}{factor with groups to use in the plot. Default NULL}

\item{limits}{values limits used for computing the data gradient for the plot}

\item{title}{plot title}

\item{z.name}{name for the legend}

\item{vertical}{should be partitioned the populations on the x axis? Default
TRUE.}

\item{interactivePlot}{Show an interactive plot via plotly? (default: TRUE)}

\item{...}{additional arguments}
}
\description{
This function generates a multivariate plot for 
a data matrix (raster), with an option for filtering the data
and to graph using groups. The resterplot graph is a flexible tools
for multiple data sources (environmental, genetic, phenotypic, etc.).
}
\examples{

 \dontrun{
data(eco.test)

# using the ecogen object "eco" to perform a multiple-lsa
con <- eco.weight(eco[["XY"]], method = "knearest", k = 4, row.sd = TRUE)
test.lsa <- eco.lsa(eco[["P"]], con = con, method = "I", nsim = 99, multi = "matrix")

# the default method for this object, is a resterplot
eco.plotLocal(test.lsa)

# adding a factor
test.lsa <- eco.lsa(eco[["P"]], con = con, method = "I",
nsim = 99, multi = "matrix", pop = eco[["S"]][,1])
eco.plotLocal(test.lsa)

# The generic rasterplot method requires a data matrix, and, as option, a condition 
# and a filter matrix. The condition is an expression, containing the word "filter" and 
# logical elements, e.g., "filter < 50", "filter <50 || filter > 2", etc. ). 
# Filter is used as a logical matrix (TRUE-FALSE, in relation to the passed condition),
# for filtering the data. If a condition is passed but not a filter matrix, the condition
# is applied over the data matrix, also using the word "filter". 
# Internally, the multi.lsa plot uses three fundamental elements. 
# - a data matrix: in the example, ecoslot.OBS(test.lsa)
#  a filter matrix: in the example, ecoslt.PVAL(test.lsa); i.e., 
the data matrix will be filtered
# by P-value using the third element, an expresion.
# - an expression: in the example: "filter < 0.05"
 
 # Combining the three elements, the multivariate plot can be manually constructed:
 my.plot <- eco.rasterplot(x= ecoslot.OBS(test.lsa), 
 filter = ecoslot.PVAL(test.lsa), condition = "filter < 0.05")
 
 
 # add population
 my.plot <- eco.rasterplot(x= ecoslot.OBS(test.lsa), 
 filter = ecoslot.PVAL(test.lsa), 
 condition = "filter < 0.05", grp = ecoslot.POP(test.lsa))
 
 
 # Extra manipulation with ggplot2 graphs (ggplot2 commands allowed by rasterplot)
 my.plot <- eco.rasterplot(x= ecoslot.OBS(test.lsa), 
 filter = ecoslot.PVAL(test.lsa), condition = "filter < 0.05",
 interactivePlot = FALSE)
 
 ## rotate plot
 
 my.plot + coord_flip()
 
 ## change design
 my.plot + theme_grey()
 
 
 # using the data as filter
 eco.rasterplot(x= ecoslot.OBS(test.lsa), filter = ecoslot.OBS(test.lsa), 
 condition = "filter > 0 & filter < 3")
 
 
 # example of bad syntax (incorrect use of && over matrices)
 eco.rasterplot(x= ecoslot.OBS(test.lsa), filter = ecoslot.OBS(test.lsa), 
 condition = "filter > 0 && filter < 3")
 
 }
 
}

