% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eco.pairtest.R
\name{eco.pairtest}
\alias{eco.pairtest}
\title{Kruskall - Wallis + Wilcoxon (Mann-Whitney U) and aov + Tukey-HSD tests 
for an ecogen object}
\usage{
eco.pairtest(eco, df = c("P", "E", "A", "C"), x, test = c("wilcoxon",
  "tukey"), adjust = "fdr", only.p = TRUE, ...)
}
\arguments{
\item{eco}{Object of class "ecogen".}

\item{df}{The data frame for the analysis. Could be "P", "E" "A" or "C".
For dominant data, "A" is here considered here a synonym of the G data frame.}

\item{x}{The name of the S slot column with the groups for the analysis.}

\item{test}{Test to perform ("wilcoxon", "tukey").}

\item{adjust}{P-values correction method for multiple tests 
passed to \code{\link[stats]{p.adjust}}. Defalut is "fdr".}

\item{only.p}{Should be only returned a matrix with P-values? 
Default TRUE.}

\item{...}{Additional arguments passed to \code{\link{wilcox.test}} 
or  \code{\link{TukeyHSD}}.}
}
\description{
Kruskall - Wallis + Wilcoxon (Mann-Whitney U) and aov + Tukey-HSD tests 
for an ecogen object
}
\details{
This program returns the Wilcoxon (Mann-Whitney U) or Tukey-HSD 
statistics and p values for the multiple comparisons of the variables contained
in the selected data frame, among the levels of a factor of the slot "S".
}
\examples{
\dontrun{
data(eco3)
wil <- eco.pairtest(eco = eco3, df = "P", x = "structure")
wil
wil <- eco.pairtest(eco = eco3,df = "E", x = "structure")
wil
wil <- eco.pairtest(eco = eco3, df = "P", x = "structure", only.p = FALSE)
wil
wil <- eco.pairtest(eco = eco3,df = "P", x = "structure", test = "tukey")
wil
}

}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}
\seealso{
\code{\link{wilcox.test}} \code{\link{TukeyHSD}}
}

