% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eco.plotCorrelog.R
\name{eco.plotCorrelog}
\alias{eco.plotCorrelog}
\title{eco.plotCorrelog}
\usage{
eco.plotCorrelog(x, var = NULL, xlabel = NULL, ylabel = NULL,
  title = NULL, legend = TRUE, background = c("grey", "white"),
  errorbar = FALSE, intervals = TRUE, significant.S = TRUE,
  significant.M = FALSE, xlim = NULL, ylim = NULL, nsim = 999,
  interactivePlot = TRUE, meanplot = TRUE, randtest = c("permutation",
  "bootstrap", "none"), alpha = 0.05, quiet = FALSE)
}
\arguments{
\item{x}{Result of correlogram or variogram analysis}

\item{var}{Individual variable to plot for multiple analyses with \code{\link{eco.correlog}} 
To plot multiple variables in a same plot, use only the argument x (see examples)}

\item{xlabel}{Label for X axis (default: NULL)}

\item{ylabel}{Label for Y axis (default: NULL)}

\item{title}{Title of the plot (default: NULL)}

\item{legend}{Show legends in ggplot graphs? (default: TRUE)}

\item{background}{Background color ("grey" or "white")}

\item{errorbar}{Show error-bars? (default: FALSE)}

\item{intervals}{Show bootstrap CI in kinship analysis? (default: TRUE)}

\item{significant.S}{With single variables and permutation test: 
show different colours for significant points? (default: TRUE)}

\item{significant.M}{With multiple variables: 
show only significant correlograms? (default: FALSE)}

\item{xlim}{X axis limits (as vector: c(min, max);  default: NULL)}

\item{ylim}{Y axis limits (as vector: c(min, max);  default: NULL)}

\item{nsim}{Number of simulations for permutation or bootstrap tests.}

\item{interactivePlot}{Show an interactive plot via plotly? (default: TRUE)}

\item{meanplot}{Show a line with the mean, when the plot is for multiple variables? (default: TRUE)}

\item{randtest}{Randomization test (one of: "permutation", "bootstrap", "none")}

\item{alpha}{significance level for P (or P-adjusted) values (Default alpha = 0.05)}

\item{quiet}{print quietly? Default FALSE}
}
\description{
Plot method for correlograms and variograms. 
For examples, see  \code{\link{eco.correlog}} \code{\link{eco.cormantel}}  \code{\link{eco.variogram}}
}
\seealso{
\code{\link{eco.correlog}} \code{\link{eco.cormantel}}  \code{\link{eco.variogram}}
}
\author{
Leandro Roser \email{learoser@gmail.com}
}
