% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ecogen.definition.R
\name{ecogen}
\alias{ecogen}
\title{Creating a new ecogen object.}
\usage{
ecogen(XY = data.frame(), P = data.frame(), G = data.frame(),
  E = data.frame(), S = data.frame(), C = data.frame(), missing = c("0",
  "NA", "MEAN"), ploidy = 2, ...)
}
\arguments{
\item{XY}{Data frame of 2 columns by n rows (individuals), in UTM format.}

\item{P}{Data frame of n rows (individuals) with phenotypic data
(traits in columns).}

\item{G}{Data frame of n rows (individuals) with genotypic data
(loci in columns).
Data should be in a format accepted by the adegenet
\code{\link[adegenet]{df2genind}} function.}

\item{E}{Data frame of n rows (individuals) with environmental data
in columns.}

\item{S}{Data frame of n rows (individuals) with group factors in columns.
Different columns indicate levels or grouping schemas (see details).}

\item{C}{data frame of n rows (individuals) with custom variables.}

\item{missing}{Argument passed to \code{\link[adegenet]{df2genind}} when
G input is a data.frame. Else, when data is of classes "DNAbin" or
"alignment", this function can operate over  missing with the same
three values ("0", "NA", or "MEAN"). Missing elements are treated as
 zeros in the default option.}

\item{ploidy}{Ploidy of the G data frame. For an haploid data frame,
ploidy =1 must be included in the function. Default ploidy = 2 for this
class of data.}

\item{...}{further arguments passed to \code{\link[adegenet]{df2genind}}
when G data is of class "data.frame", otherwise are passed to
\code{\link[adegenet]{DNAbin2genind}} when G data is of class "DNAbin" or to
\code{\link[adegenet]{alignment2genind}} when data is of class "alignment".}
}
\description{
Creating a new ecogen object.
}
\details{
This is a generic function for creating an ecogen object. The non
genetic data must be of class "data.frame". For the genetic data, there are
three options: Data of "data.frame" class, (for example, microsatellite,
AFLP, RAPD, etc.); data of "DNAbin" class (ape data). The program
recognizes the classes and can discern a codominant data frame from a
presence - absence data frame. When data is composed entirely of two
values, the program takes these data is of presence - absence
type.
Cells in data frames with missing data must be filled with 0.
}
\examples{
\dontrun{

#Example with G data of class "data.frame", corresponding to
#microsatellites of a diploid organism:
data(eco.test)
eco <- ecogen(XY = coordinates, P = phenotype, G = genotype,
E = environment, S = as.data.frame(structure))
eco <- eco.sortalleles(eco, 1)

#Example with G data of class "data.frame", corresponding to a
#presence - absence molecular marker:
dat <- sample(c(0,1),100,rep = TRUE)
dat <- data.frame(matrix(dat,10,10))
eco <- ecogen(G = dat)

#Example with G data of class "DNAbin":
require(ape)
data(woodmouse)
G <- woodmouse
eco <- ecogen( G = G)

#Example with G data of class "alignment":
require(seqinr)
data(mase)
G <- mase
eco <- ecogen( G = G)

}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}
\seealso{
\code{\link[adegenet]{df2genind}}
}

