% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetapopulationClass.R
\name{simulate,Metapopulation-method}
\alias{simulate,Metapopulation-method}
\title{Simulate method for the \code{Metapopulation} class}
\usage{
\S4method{simulate}{Metapopulation}(
  object,
  nsim = 1,
  seed = NULL,
  threshold = 500,
  includefreqGeno = TRUE,
  recording = FALSE,
  recordGenGap = 1,
  drift = TRUE,
  includeParams = TRUE,
  includeFitness = TRUE,
  verbose = FALSE,
  stopCondition = list(),
  nameOutFunct = "outFunct"
)
}
\arguments{
\item{object}{a \code{Metapopulation} object}

\item{nsim}{the number of simulation to perform}

\item{seed}{the RNG seed to be fixed (allows exact reproduction of
results)}

\item{threshold}{maximum duration of a simulation (in generations)}

\item{includefreqGeno}{a logical indicating whether to include genotype
frequencies in the results}

\item{recording}{a logical indicating whether to record all mutations, i.e.
to record allelic and genotypic frequencies along the simulations}

\item{recordGenGap}{the number of generations between two records during
simulation, if the record parameter is TRUE. Whatever the value of this
parameter, both the first and the last generation will be included in
the record}

\item{drift}{a logical indicating whether genetic drift should be
considered (i.e. whether deterministic simulations are performed or not)}

\item{includeParams}{a logical indicating whether the parameters should be
included in the result data.frame (can be useful when compiling multiple
result tables)}

\item{includeFitness}{a logical indicating whether the mean fitness should
be included in the result data.frame (can be useful when compiling multiple
result tables)}

\item{verbose}{logical determining if the progress of the simulations should
be displayed or not (useful in case of many simulations)}

\item{stopCondition}{list of vectors that each describe the allele(s) that
must be fixed to define a stop condition. Each of these vectors
will therefore be associated with a stop condition}

\item{nameOutFunct}{name of the custom output function. This function is
called each generation in each population of a simulation and systematically
returns a list with the first element being a logic that indicates whether
something should be saved. If so, the second element of this
list will be saved.If the customOutFunct parameter is null (default),
there will be no custom output.}
}
\value{
An \code{Metapopulation} object from which we can now extract the results
(or the records if recording = TRUE) with the getResults and getRecords
functions.
}
\description{
Performing simulations of an Metapopulation object. The returned object is the same
Metapopulation object completed with the results and records if they have been
activated.
}
\author{
Ehouarn Le Faou
}
