% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelFunctions.R
\name{outFunct}
\alias{outFunct}
\title{Custom output function}
\usage{
outFunct(pop)
}
\arguments{
\item{pop}{list of some characteristics of the population :
- customOutput : list of all previous savings
- gen : generation
- freqGeno : list of genotypic frequency matrices (matrix 1 x # genotypes).
The list is constructed as follows: if the population is hermaphroditic it
has only one element "ind", if the population is dioecious it has three
elements, "female", "male" and "ind" which correspond respectively to
the genotypic frequencies of the females, the males and the average of
the two (assuming a sex ratio of 50:50).
- freqHaplo : list of genotypic frequency matrices (matrix 1 x # haplotypes).
The list is constructed in the same way as for genotypic frequencies (see
above).
- freqAlleles : list of allelic frequency matrices (matrix 1 x # alleles).
The list is constructed in the same way as for genotypic frequencies (see
above).}
}
\description{
Allow to produce a custom output for a simulation.
}
\details{
This function is called each generation in each population of a simulation
and systematically returns a list with the first element being a logic that
indicates whether something should be saved. If so, the second element
of this list will be saved.

By default the save nothing function, but it can be changed by the user as
an argument in the \code{simulate} method of the \code{Metapopulation}
class.
}
\author{
Ehouarn Le Faou
}
