% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EValue.R
\name{evalues.RD}
\alias{evalues.RD}
\title{Compute E-value for a population-standardized risk difference and its confidence interval limits}
\usage{
evalues.RD(n11, n10, n01, n00, true = 0, alpha = 0.05, grid = 1e-04)
}
\arguments{
\item{n11}{Number of exposed, diseased individuals}

\item{n10}{Number of exposed, non-diseased individuals}

\item{n01}{Number of unexposed, diseased individuals}

\item{n00}{Number of unexposed, non-diseased individuals}

\item{true}{True value of risk difference to which to shift the point estimate. Usually set to 0 to consider the null.}

\item{alpha}{Alpha level}

\item{grid}{Spacing for grid search of E-value}
}
\description{
Returns E-values for the point estimate and the lower confidence interval limit for a positive risk difference. 
If the risk difference is negative, the exposure coding should be first be reversed to yield a positive risk difference.
}
\examples{

## example 1     
## Hammond and Holl (1958 JAMA) Data
## Two by Two Table
##          Lung Cancer    No Lung Cancer
##Smoker    397            78557
##Nonsmoker 51             108778

# E-value to shift observed risk difference to 0
evalues.RD( 397, 78557, 51, 108778)

# E-values to shift observed risk difference to other null values
evalues.RD( 397, 78557, 51, 108778, true = 0.001)
}
