% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ETRep_Functions.R
\name{tube_Surface_Mesh}
\alias{tube_Surface_Mesh}
\title{Create surface mesh of a tube}
\usage{
tube_Surface_Mesh(
  tube,
  meshType = "quadrilateral",
  plotMesh = TRUE,
  color = "blue",
  decorate = TRUE
)
}
\arguments{
\item{tube}{List containing ETRep details.}

\item{meshType}{String, either "quadrilateral" or "triangular" definig the type of mesh.}

\item{plotMesh}{Logical, enables plotting of the mesh (default is TRUE).}

\item{color}{String, defining the color of the mesh (default is 'blue').}

\item{decorate}{Logical, enables decorating the plot (default is TRUE).}
}
\value{
An object from rgl::mesh3d class
}
\description{
Create surface mesh of a tube
}
\examples{
quad_mesh<-tube_Surface_Mesh(tube = ETRep::tube_B, 
                             meshType = "quadrilateral", 
                             plotMesh = TRUE, 
                             decorate = TRUE, 
                             color = "orange")
tri_mesh<-tube_Surface_Mesh(tube = ETRep::tube_B, 
                            meshType = "triangular", 
                            plotMesh = TRUE, 
                            decorate = TRUE, 
                            color = "green")
}
