% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ETRep_Functions.R
\name{simulate_etube}
\alias{simulate_etube}
\title{Simulate Random Elliptical Tubes (ETReps)}
\usage{
simulate_etube(
  referenceTube,
  numberOfSimulation,
  sd_v = 10^-10,
  sd_psi = 10^-10,
  sd_x = 10^-10,
  sd_a = 10^-10,
  sd_b = 10^-10,
  rangeSdScale = c(1, 2),
  plotting = TRUE
)
}
\arguments{
\item{referenceTube}{List containing ETRep information as the reference.}

\item{numberOfSimulation}{Integer, number of random samples.}

\item{sd_v}{Standard deviations for various parameters.}

\item{sd_psi}{Standard deviations for various parameters.}

\item{sd_x}{Standard deviations for various parameters.}

\item{sd_a}{Standard deviations for various parameters.}

\item{sd_b}{Standard deviations for various parameters.}

\item{rangeSdScale}{Numeric range for random scaling.}

\item{plotting}{Logical, enables visualization of samples (default is FALSE).}
}
\value{
List of random ETReps.
}
\description{
Generates random samples of ETReps based on a reference tube with added variation.
}
\examples{
# Load tube
data("colon3D")
#Set Parameters
sd_v<-sd_psi<-1e-03
sd_x<-sd_a<-sd_b<-1e-04
numberOfSimulation<-3
random_Tubes<-
  simulate_etube(referenceTube = colon3D,
                 numberOfSimulation = numberOfSimulation,
                 sd_v = sd_v,
                 sd_psi = sd_psi,
                 sd_x = sd_x,
                 sd_a = sd_a,
                 sd_b = sd_b,
                 rangeSdScale = c(1, 2),
                 plotting = FALSE)
# Plotting
rgl::open3d()
for (i in 1:numberOfSimulation) {
  plot_Elliptical_Tube(tube = random_Tubes[[i]],
                       plot_frames = FALSE,
                       plot_skeletal_sheet = FALSE,
                       plot_r_project = FALSE,
                       plot_r_max = FALSE,
                       add = TRUE)
}
}
\references{
Taheri, M., Pizer, S. M., & Schulz, J. (2024). "The Mean Shape under the Relative Curvature Condition." arXiv.
\doi{10.48550/arXiv.2404.01043}

Taheri Shalmani, M. (2024). "Shape Statistics via Skeletal Structures." University of Stavanger.
\doi{10.13140/RG.2.2.34500.23685}
}
