% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{esgmcprices}
\alias{esgmcprices}
\title{Estimation of discounted asset prices}
\usage{
esgmcprices(r, X, maturity = NULL)
}
\arguments{
\item{r}{a \code{numeric} or a time series object, the risk-free rate(s).}

\item{X}{asset prices obtained with \code{\link{simdiff}}}

\item{maturity}{the corresponding maturity (optional). If missing, all the maturities 
available in \code{X} are used.}
}
\description{
This function computes estimators (sample mean) of 

\deqn{E[X_T exp(-\int_0^T r_s ds)]}

where \eqn{X_T} is an asset value at given maturities \eqn{T}, and 
\eqn{(r_s)_s} is the risk-free rate.
}
\examples{

# GBM

r <- 0.03

eps0 <- simshocks(n = 100, horizon = 5, frequency = "quart")
sim.GBM <- simdiff(n = 100, horizon = 5, frequency = "quart",   
               model = "GBM", 
               x0 = 100, theta1 = 0.03, theta2 = 0.1, 
               eps = eps0)

# monte carlo prices
esgmcprices(r, sim.GBM)

# monte carlo price for a given maturity
esgmcprices(r, sim.GBM, 2)

}
\seealso{
\code{\link{esgdiscountfactor}}, \code{\link{esgmccv}}
}
\author{
Thierry Moudiki
}
