% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{esgmccv}
\alias{esgmccv}
\title{Convergence of Monte Carlo prices}
\usage{
esgmccv(r, X, maturity, plot = TRUE, ...)
}
\arguments{
\item{r}{a \code{numeric} or a time series object, the risk-free rate(s).}

\item{X}{asset prices obtained with \code{\link{simdiff}}}

\item{maturity}{the corresponding maturity (optional). If missing, all the maturities 
available in \code{X} are used.}

\item{plot}{if \code{TRUE} (default), a plot of the convergence is displayed.}

\item{...}{additional parameters provided to \code{\link{matplot}}}
}
\value{
a list with estimated average prices and the confidence intervals around them.
}
\description{
This function computes and plots confidence intervals around the estimated 
average price, as functions of the number of simulations.
}
\details{
Studying the convergence of the sample mean of :

\deqn{E[X_T exp(-\int_0^T r_s ds)]}

towards its true value.
}
\examples{

r <- 0.03

set.seed(1)
eps0 <- simshocks(n = 100, horizon = 5, frequency = "quart")
sim.GBM <- simdiff(n = 100, horizon = 5, frequency = "quart",   
               model = "GBM", 
               x0 = 100, theta1 = 0.03, theta2 = 0.1, 
               eps = eps0)

# monte carlo prices
esgmcprices(r, sim.GBM)

# convergence to a specific price
(esgmccv(r, sim.GBM, 2))

}
\author{
Thierry Moudiki
}
