% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{esgmartingaletest}
\alias{esgmartingaletest}
\title{Martingale and market consistency tests}
\usage{
esgmartingaletest(r, X, p0, alpha = 0.05)
}
\arguments{
\item{r}{a \code{numeric} or a time series object, the risk-free rate(s).}

\item{X}{a time series object, containing payoffs or projected asset values.}

\item{p0}{a \code{numeric} or a vector or a univariate time series containing
initial price(s) of an asset.}

\item{alpha}{1 - confidence level for the test. Default value is 0.05.}
}
\value{
The function result can be just displayed. Otherwise, you can get a list 
by an assignation, containing (for each maturity) : 
\itemize{
\item the Student t values 
\item the p-values 
\item the estimated mean
of the martingale difference
\item  Monte Carlo prices
}
}
\description{
This function performs martingale and market consistency (t-)tests.
}
\examples{

r0 <- 0.03
S0 <- 100

set.seed(10)
eps0 <- simshocks(n = 100, horizon = 3, frequency = "quart")
sim.GBM <- simdiff(n = 100, horizon = 3, frequency = "quart",   
               model = "GBM", 
               x0 = S0, theta1 = r0, theta2 = 0.1, 
               eps = eps0)

mc.test <- esgmartingaletest(r = r0, X = sim.GBM, p0 = S0, 
alpha = 0.05)                               
esgplotbands(mc.test)                

}
\seealso{
\code{\link{esgplotbands}}
}
\author{
Thierry Moudiki
}
