\name{esgcortest}
\alias{esgcortest}
\title{Correlation tests for the shocks}
\usage{
  esgcortest(x,
    alternative = c("two.sided", "less", "greater"),
    method = c("pearson", "kendall", "spearman"),
    conf.level = 0.95)
}
\arguments{
  \item{x}{gaussian (bivariate) shocks, with correlation,
  generated by \code{\link{simshocks}}.}

  \item{alternative}{indicates the alternative hypothesis
  and must be one of "two.sided", "greater" or "less".}

  \item{method}{which correlation coefficient is to be used
  for the test : "pearson", "kendall", or "spearman".}

  \item{conf.level}{confidence level.}
}
\value{
  a list with 2 components : estimated correlation
  coefficients, and confidence intervals for the estimated
  correlations.
}
\description{
  This function performs correlation tests for the shocks
  generated by \code{\link{simshocks}}.
}
\examples{
nb <- 500

s0.par1 <- simshocks(n = nb, horizon = 3, frequency = "semi",
family = 1, par = 0.2)

s0.par2 <- simshocks(n = nb, horizon = 3, frequency = "semi",
family = 1, par = 0.8)

(test1 <- esgcortest(s0.par1))
(test2 <- esgcortest(s0.par2))
par(mfrow=c(2, 1))
esgplotbands(test1)
esgplotbands(test2)
}
\author{
  Thierry Moudiki + stats package
}
\references{
  D. J. Best & D. E. Roberts (1975), Algorithm AS 89: The
  Upper Tail Probabilities of Spearman's rho. Applied
  Statistics, 24, 377-379.

  Myles Hollander & Douglas A. Wolfe (1973), Nonparametric
  Statistical Methods. New York: John Wiley & Sons. Pages
  185-194 (Kendall and Spearman tests).
}
\seealso{
  \code{\link{esgplotbands}}
}

