% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BC_RKL.R
\name{RKL}
\alias{RKL}
\title{Calculate rank last}
\usage{
RKL(y, phat, ...)
}
\arguments{
\item{y}{True (binary) response vector where 1 is the rare/relevant class.}

\item{phat}{Numeric vector of estimated probabilities of relevance.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Numeric value of RKL.
}
\description{
The peformance measure rank last (RKL) is calculated as follows: after
ranking the observations in decreasing order via \code{phat}, RKL is the rank
of the last truly relevant observation. Hence, RKL can take on integer values
from 1 to \eqn{n}, where \eqn{n} is the total number of observations. If
there are ties, the last object in the tied group determines RKL. That is, if
all \eqn{n} objects are tied at the first rank but only one object is truly
relevant, RKL will have a value of \eqn{n}.
}
\examples{
## without ties in phat
\donttest{
resp <- c(rep(1, 50), rep(0, 50))
prob <- (1:100)*0.01
RKL(y = resp, phat = prob) # expect 100

resp <- c(rep(0, 50), rep(1, 50))
RKL(y = resp, phat = prob) # expect 50

## with ties in phat
resp <- sample(c(1, 0), 100, replace = TRUE)
prob <- rep(1, 100)
RKL(y = resp, phat = prob) # expect 100
}
}
