% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/background.raster.buffer.R
\name{background.raster.buffer}
\alias{background.raster.buffer}
\title{Takes a set of points, a buffer radius, and a mask and returns
a raster based on that buffer radius.
Code modified from Elith and Hijmans SDM with R tutorial}
\usage{
background.raster.buffer(points, radius, mask)
}
\arguments{
\item{points}{A two column data frame with X and Y coordinates}

\item{radius}{Radius for circular buffers to draw around points, in meters.}

\item{mask}{A raster to use as a mask}
}
\value{
A raster object with values of 1 in every grid cell falling within the buffer.
}
\description{
Takes a set of points, a buffer radius, and a mask and returns
a raster based on that buffer radius.
Code modified from Elith and Hijmans SDM with R tutorial
}
\examples{
data(iberolacerta.clade)
data(euro.worldclim)
background.raster.buffer(iberolacerta.clade$species$cyreni$presence.points, 100000, euro.worldclim)
}
