% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{stts}
\alias{stts}
\alias{stts,binClst-method}
\alias{stts,binClstStck-method}
\title{Clustering statistics.}
\usage{
stts(obj, dec = 2, width = 8)

\S4method{stts}{binClst}(obj, dec = 2, width = 8)

\S4method{stts}{binClstStck}(obj, dec = 2, width = 8)
}
\arguments{
\item{obj}{Either a \link{binClst_instance} or a \code{binClstStck} instance.
  In the latter case statistics are given at stack level.}

\item{dec}{The number of decimals for mean/stdv formatting.}

\item{width}{The number of digits for mean/stdv formatting.}
}
\description{
\code{stts} clustering statistics information.
}
\details{
This method prints a line for each cluster with the following information:
the cluster number, the cluster binary label, the cluster mean and variance
of each input feature (two columns for each variable), and the size of the
cluster in number and proportion of points (the posterior marginal
distribution).
}
\examples{
# -- apply EMbC to the example path with solar covariate 'height'--
mybcp <- stbc(expth,scv='height',info=-1)
# -- show clustering statistics --
stts(mybcp,width=5,dec=1)
\dontrun{
# -- show clustering statistics of mybcpstack at stack level --
stts(mybcpstack)
# -- show individual statistics for path number 3 in mybcpstack --
stts(slct(mybcpstack,3))
}
}

