\name{filterAnnotations}
\alias{filterAnnotations}
\title{Filter output of EMVC algorithm}
\description{
  Filters the output of the EMVC algorithm to remove all annotations whose bootstrap annotation probability is below a specified threshold.
}
\usage{
    filterAnnotations(annotations, proportion)
}
\arguments{
\item{annotations}{Optimized annotation matrix returned by function \code{EMVC}. Rows represent gene sets and columns represent genes. 
    Elements of the matrix represent the proportion of clusterings within all bootstrap resampled data sets in which the annotation was not filtered by EMVC.}
\item{proportion}{Threshold for annotation filtering. All annotations whose optimization proportion is below this value will be filtered.}
}
\value{
Updated version of the input annotation matrix that contains only those annotations
with proportions greater than or equal to the specified threshold. Elements in this matrix are either 0 or 1.
}
\seealso{
      \code{\link{EMVC}}.
}
\examples{

   ## Create random optimized annotation matrix for 50 gene sets and 100 genes. 
   ## This mimics what is generated by the EMVC() function 
   opt.annotations = matrix(runif(5000), nrow=50, ncol=100)
    
   ## Total number of non-zero annotations
   length(which(opt.annotations > 0))

   ## Filter the results at .5 threshold. The number should be approximately half 
   ## of the non-zero annotations since the proportions were generated as uniform(0,1)
   filtered.opt.annotations = filterAnnotations(opt.annotations, .5)
   sum(filtered.opt.annotations)
      
}
\keyword{file}