% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolate.classes.R
\name{interpolate.classes}
\alias{interpolate.classes}
\title{Interpolate data between different classes.}
\usage{
interpolate.classes(X, boundaries.in, boundaries.out, method = "natural",
  fixed.start = TRUE)
}
\arguments{
\item{X}{\code{Numeric} matrix, input data set with m samples (rows) 
and n variables (columns).}

\item{boundaries.in}{\code{Numeric} vector, class boundaries of the 
input data.}

\item{boundaries.out}{\code{Numeric} vector, class boundaries of the output
data.}

\item{method}{\code{Logical} scalar, interpolation method, one out of 
"linear" (linear interpolation), "fmm" (cubic spline), "natural" 
(natural spline), "periodic" (periodic spline). Default is \code{"natural"}.}

\item{fixed.start}{\code{Logocal} scalar, specifying if the outer boundaries 
should be set to the same values as in the original matrix, default is 
\code{TRUE}. This may become necessary to avoid interpolation errors, see 
example.}
}
\value{
\code{Numeric} matrix, interpolated class values.
}
\description{
This function interpolates grain-size data for different classes, either to 
higher or to lower resolution.
}
\examples{

## load example data
data(example_X)
classes.in <- seq(from = 1, to = 10, length.out = ncol(X))
  
## Example 1 - decrease the class numbers
## define number of output classes
classes.out <- seq(1, 10, length.out = 20)

## interpolate the data set
Y <- interpolate.classes(X = X, 
                         boundaries.in = classes.in, 
                         boundaries.out = classes.out,
                         method = "linear")

## show original vs. interpolation for first 10 samples
plot(NA, xlim = c(1, 10), ylim = c(0, 40))
for(i in 1:10) {
  lines(classes.in, X[i,] * 20 + i)
  lines(classes.out, Y[i,] * 20 + i, col = 2)
}

## Example 2 - increase the class numbers
## define number of output classes
classes.out <- seq(1, 10, length.out = 200)

## interpolate the data set
Y <- interpolate.classes(X = X, 
                         boundaries.in = classes.in, 
                         boundaries.out = classes.out)

## show original vs. interpolation for first 10 samples
plot(NA, xlim = c(1, 10), ylim = c(0, 40))
for(i in 1:10) {
  lines(classes.in, X[i,] * 20 + i)
  lines(classes.out, Y[i,] * 20 + i, col = 2)
}

}
\seealso{
\code{\link{EMMA}}, \code{\link{approx}}, \code{\link{spline}}
}
\author{
Michael Dietze, Elisabeth Dietze
}
\keyword{EMMA}
