% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plot_emdnull}
\alias{plot_emdnull}
\title{Plot null distribution of permuted EMD scores vs. calculated EMD
scores.}
\usage{
plot_emdnull(emdobj)
}
\arguments{
\item{emdobj}{An \code{\link{EMDomics}} object, typically returned via a call
to \code{\link{calculate_emd}}.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object is returned. If the value is
not assigned, a plot will be drawn.
}
\description{
The median of the randomly permuted EMD scores (i.e. the null
distribution) is plotted on the x-axis, vs. the observed EMD scores on the
y-axis. The line \code{y=x} is superimposed.
}
\examples{
# 100 genes, 100 samples
dat <- matrix(rnorm(10000), nrow=100, ncol=100)
rownames(dat) <- paste("gene", 1:100, sep="")
colnames(dat) <- paste("sample", 1:100, sep="")

# "group A" = first 50, "group B" = second 50
groupA <- colnames(dat)[1:50]
groupB <- colnames(dat)[51:100]

results <- calculate_emd(dat, groupA, groupB, nperm=10)
plot_emdnull(results)
}
\seealso{
\code{\link{calculate_emd}} \code{\link[ggplot2]{ggplot}}
}

