% Generated by roxygen2 (4.0.2): do not edit by hand
\name{calculate_emd_gene}
\alias{calculate_emd_gene}
\title{Calculate EMD score for a single gene}
\usage{
calculate_emd_gene(vec, samplesA, samplesB, binSize = 0.2)
}
\arguments{
\item{vec}{A named vector containing data (e.g. expression data) for a single
gene.}

\item{samplesA}{A vector of sample names identifying samples in \code{vec}
that belong to "group A".}

\item{samplesB}{A vector of sample names identifying samples in \code{vec}
that belong to "group B".}

\item{binSize}{The bin size to be used when generating histograms for
"group A" and "group B".}
}
\value{
The emd score is returned.
}
\description{
Calculate EMD score for a single gene
}
\details{
The data in \code{vec} is divided into "group A" and "group B" by the
identifiers given in \code{samplesA} and \code{samplesB}. The \code{\link{hist}}
function is used to generate histograms for the two resulting groups, and the
densities are retrieved and passed to \code{\link[emdist]{emd2d}} to compute the
EMD score.
}
\examples{
# 100 samples
vec <- rnorm(100)
names(vec) <- paste("sample", 1:100, sep="")

# "group A" = first 50, "group B" = second 50
groupA <- names(vec)[1:50]
groupB <- names(vec)[51:100]

calculate_emd_gene(vec, groupA, groupB)
}
\seealso{
\code{\link[emdist]{emd2d}}
}

