% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_pars}
\alias{plot_pars}
\title{Plots Density for Parameters}
\usage{
plot_pars(
  emc,
  layout = NA,
  selection = "mu",
  show_chains = FALSE,
  plot_prior = TRUE,
  N = 10000,
  use_prior_lim = !all_subjects,
  lpos = "topright",
  true_pars = NULL,
  all_subjects = FALSE,
  prior_args = list(),
  true_args = list(),
  ...
)
}
\arguments{
\item{emc}{An emc object}

\item{layout}{A vector indicating which layout to use as in par(mfrow = layout). If NA, will automatically generate an appropriate layout.}

\item{selection}{A Character string. Indicates which parameter type to use (e.g., \code{alpha}, \code{mu}, \code{sigma2}, \code{correlation}).}

\item{show_chains}{Boolean (defaults to \code{FALSE}) plots a separate density for each chain.}

\item{plot_prior}{Boolean. If \code{TRUE} will overlay prior density in the plot (default in red)}

\item{N}{Integer. How many prior samples to draw}

\item{use_prior_lim}{Boolean. If \code{TRUE} will use xlimits based on prior density, otherwise based on posterior density.}

\item{lpos}{Character. Where to plot the contraction statistic.}

\item{true_pars}{A vector or emc object. Can be used to visualize recovery.
If a vector will plot a vertical line for each parameter at the appropriate place.
If an emc object will plot the densities of the object as well, assumed to be the data-generating posteriors.}

\item{all_subjects}{Boolean. Will plot the densities of all (selected) subjects overlaid with the group-level distribution}

\item{prior_args}{A list. Optional additional arguments to be passed to plot.default for the plotting of the prior density (see \code{par()})}

\item{true_args}{A list. Optional additional arguments to be passed to plot.default for the plotting of the true parameters (see \code{par()})}

\item{...}{Optional arguments that can be passed to \code{get_pars}, \code{density}, or \code{plot.default} (see \code{par()})}
}
\value{
An invisible return of the contraction statistics for the selected parameter type
}
\description{
Plots the posterior and prior density for selected parameters of a model.
Full range of samples manipulations described in \code{get_pars}.
}
\examples{
# Full range of possibilities described in get_pars
plot_pars(samples_LNR)
# Or plot all subjects
plot_pars(samples_LNR, all_subjects = TRUE, col = 'purple')
# Or plot recovery
true_emc <- samples_LNR # This would normally be the data-generating samples
plot_pars(samples_LNR, true_pars = true_emc, true_args = list(col = 'blue'), adjust = 2)
}
