% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SBC.R
\name{run_sbc}
\alias{run_sbc}
\title{Simulation-based calibration}
\usage{
run_sbc(
  design_in,
  prior_in,
  replicates = 250,
  trials = 100,
  n_subjects = 30,
  plot_data = FALSE,
  verbose = TRUE,
  fileName = NULL,
  ...
)
}
\arguments{
\item{design_in}{An emc design list. The design of the model to be used in SBC}

\item{prior_in}{An emc prior list. The prior for the design to be used in SBC}

\item{replicates}{Integer. The number of samples to draw from the prior}

\item{trials}{Integer. The number of trials of the simulated data (per subject)}

\item{n_subjects}{Integer. Only used for hierarchical models. The number of subjects to be used in data generation of each replicate}

\item{plot_data}{Boolean. Whether to plot the data simulated (aggregated across subjects)}

\item{verbose}{Verbose. Whether to print progress related messages}

\item{fileName}{Character. Highly recommended, saves temporary results to the fileName}

\item{...}{A list of optional additional arguments that can be passed to \code{fit} and \code{make_emc}}
}
\value{
The ranks and prior samples. For hierarchical models also the prior-generated subject-level parameters.
}
\description{
Runs SBC for an EMC2 model and associated design. Returns
normalized rank (between 0 and 1) and prior samples. For hierarchical models the group-level mean and
the (implied) group-level (co-)variance are returned.
For non-hierarchical models only the subject-level parameters rank is returned.
}
