% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_funcs.R
\name{recovery.emc}
\alias{recovery.emc}
\alias{recovery}
\title{Recovery plots}
\usage{
\method{recovery}{emc}(
  emc,
  true_pars,
  selection = "mu",
  layout = NA,
  do_CI = TRUE,
  correlation = "pearson",
  stat = "rmse",
  digits = 3,
  CI = 0.95,
  ci_plot_args = list(),
  ...
)

recovery(emc, ...)
}
\arguments{
\item{emc}{An emc object}

\item{true_pars}{A vector of data-generating parameters or an emc object with data-generating samples}

\item{selection}{A Character vector. Indicates which parameter types to plot (e.g., \code{alpha}, \code{mu}, \code{sigma2}, \code{correlation}).}

\item{layout}{A vector indicating which layout to use as in par(mfrow = layout). If NA, will automatically generate an appropriate layout.}

\item{do_CI}{Boolean. If \code{TRUE} will also include bars representing the credible intervals}

\item{correlation}{Character. Which correlation to include in the plot. Options are either \code{pearson} or \code{spearman}}

\item{stat}{Character. Which statistic to include in the plot. Options are either \code{rmse} or \code{coverage}}

\item{digits}{Integer. How many digits to round the statistic and correlation in the plot to}

\item{CI}{Numeric. The size of the credible intervals. Default is .95 (95\%).}

\item{ci_plot_args}{A list. Optional additional arguments to be passed to plot.default for the plotting of the credible intervals (see \code{par()})}

\item{...}{Optional arguments that can be passed to \code{get_pars} or \code{plot.default} (see \code{par()})}
}
\value{
Invisible list with RMSE, coverage, and Pearson and Spearman correlations.
}
\description{
Plots recovery of data generating parameters/samples.
Full range of samples manipulations described in \code{get_pars}
}
\examples{
# Make up some values that resemble posterior samples
# Normally this would be true values that were used to simulate the data
# Make up some values that resemble posterior samples
# Normally this would be true values that were used to simulate the data
pmat <- matrix(rnorm(12, mean = c(-1, -.6, -.4, -1.5), sd = .01), ncol = 4, byrow = TRUE)
# Conventionally this would be created before one makes data with true values
recovery(samples_LNR, pmat, correlation = "pearson", stat = "rmse", selection = "alpha")
# Similarly we can plot recovery of other parameters with a set of true samples
true_samples <- samples_LNR # Normally this would be data-generating samples
recovery(samples_LNR, true_samples, correlation = "pearson", stat = "rmse",
         selection = "correlation", cex = 1.5,
         ci_plot_args = list(lty = 3, length = .2, lwd = 2, col = "brown"))
}
