% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_analysis.R
\name{standardize_loadings}
\alias{standardize_loadings}
\title{Standardized factor loadings}
\usage{
standardize_loadings(
  emc = NULL,
  loadings = NULL,
  sig_err_inv = NULL,
  stage = "sample",
  merge_chains = TRUE
)
}
\arguments{
\item{emc}{An emc object with samples from a hierarchical factor analysis model}

\item{loadings}{Array of pars by factors by iters. Can also specify loadings instead of emc}

\item{sig_err_inv}{Array of pars by iters. Can also specify sig_err_inv instead of emc}

\item{stage}{Character. From which stage to take samples}

\item{merge_chains}{Return the loadings for each chain separately or merged together.}
}
\value{
standardized loadings
}
\description{
Returns a set of standardized factor loadings.
The standardization considers the residual error as well
as described in Stevenson, Heathcote, Forstmann & Matzke, 2024.
}
