% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting.R
\name{run_IS2}
\alias{run_IS2}
\title{Runs IS2 from Tran et al. 2021 on a list of emc}
\usage{
run_IS2(
  emc,
  stage = "sample",
  filter = 0,
  IS_samples = 1000,
  stepsize_particles = 500,
  max_particles = 5000,
  n_cores = 1,
  df = 5
)
}
\arguments{
\item{emc}{A list of emc}

\item{stage}{A string. Indicates which stage to take samples from}

\item{filter}{An integer or vector. If integer specifies how many samples to remove from within that stage. If vector used as index for samples to keep.}

\item{IS_samples}{An integer. Specifies how many IS2 samples to collect}

\item{stepsize_particles}{An integer. It will increase particles till optimal variance with this stepsize.}

\item{max_particles}{An integer. Specifies the maximum number of particles to collect before stopping one IS iteration.}

\item{n_cores}{An integer. Specifies how many cores to run IS_2 on.}

\item{df}{An integer. The degrees of freedom used in the t-distribution used as IS distribution for the group-level proposals.}
}
\value{
emc, with IS2 attribute
}
\description{
Runs IS2 on a list of emc, only works for types standard, factor and diagonal yet.
}
