% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_funcs.R
\name{parameters.emc}
\alias{parameters.emc}
\alias{parameters}
\title{Returns a parameter type from an emc object as a data frame.}
\usage{
\method{parameters}{emc}(emc, selection = "mu", N = NULL, resample = FALSE, ...)

parameters(emc, ...)
}
\arguments{
\item{emc}{An emc object}

\item{selection}{String designating parameter type (e.g. mu, sigma2, correlation, alpha)}

\item{N}{Integer. How many samples to take from the posterior. If \code{NULL} will return the full posterior}

\item{resample}{Boolean. If \code{TRUE} will sample N samples from the posterior with replacement}

\item{...}{Optional arguments that can be passed to \code{get_pars}}
}
\value{
A data frame with one row for each sample (with a subjects column if selection = "alpha")
}
\description{
Returns a parameter type from an emc object as a data frame.
}
