% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ELISAplate.R
\name{elisa_run}
\alias{elisa_run}
\title{Constructor function to build an elisa_run object}
\usage{
elisa_run(
  batchID = NA_character_,
  desc = NA_character_,
  plates = list(),
  num.plates = 1,
  date = NA_character_,
  range.ODs = c(-1, -1)
)
}
\arguments{
\item{batchID}{characters to specify the batch}

\item{desc}{characters for data/experiment information}

\item{plates}{list of elisa_plates in this run. could be one or many}

\item{num.plates}{numeric the number of plates in this run.}

\item{date}{charaters the date to run ELISA measurements}

\item{range.ODs}{numeric the range of ODs for the measurements}
}
\value{
an elisa_run object
}
\description{
S3 method as a constructor to build the S4 
class object of elisa_run \code{\link{elisa_run-class}}
}
\details{
S3 method as a constructor to build the S4 
class object of elisa_run \code{\link{elisa_run-class}}. 
Normally this is called to build a empty object 
with default values and then load the elisa_run data into.
#
}
\examples{
elisa_run();
}
\seealso{
\code{\link{nls.lm}} \code{\link{elisa_run-class}} \code{\link{elisa_plate-class}}
}
