% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_MM.R
\name{MM_est}
\alias{MM_est}
\title{Estimation of single Michaelis-Menten constant}
\usage{
MM_est(method = T, time, species, enz, subs, MM, catal, tun = 2.4, std,
  nrepeat, jump = 1, burning = 0, MM_m = 1, MM_v = 1e+06)
}
\arguments{
\item{method}{method selection: T=TQ model, F=SQ model(default = T)}

\item{time}{observed time interval}

\item{species}{observed trajectory of product}

\item{enz}{enzyme concentration}

\item{subs}{substrate concentration}

\item{MM}{initial value of MM constant}

\item{catal}{true value of catalytic constant}

\item{tun}{tunning constant of MH algorithm (default=2.4)}

\item{std}{standard deviation of proposal distribution (if =0, caclulated by Opt. function)}

\item{nrepeat}{total number of iteration (default=10000)}

\item{jump}{length of distance (default =1)}

\item{burning}{lenth of burning period (default =0)}

\item{MM_m}{prior mean of gamma prior (default =1)}

\item{MM_v}{prior variance of gamma prior (default =10000)}
}
\value{
A vector of posterior samples of Michaelis-Menten constant
}
\description{
The function estimates MM constant using input data set
and enzyme, substrate concentration, and catalytic constant.
}
\details{
The function MM_est generates a set of Markov Chain Monte Carlo
simulation samples from posterior distribution of MM
constant of enzyme kinetics model. Because the function considers
MM constant as a parameter to be estimated, the user should
input three constants of enzyme concentration, substrate concentration
and catalytic constant.
prior information for MM constant can be given.
The turning constant and standard deviation can be set to controlled proper mixing
and acceptance ratio of MM constant from it's posterior distribution.
Posterior samples are only stored with fixed interval according to set "jump"
to reduce serial correlation
The initial iterations are removed for convergence. The burning is set the length of
initial iterations.
}
\examples{
data("Chymo_low")
time1=Chymo_low[,1]
species1=Chymo_low[,2]
 Chymotrypsin.mm<-MM_est(method=TRUE,time=time1,species=species1,enz=4.4e+7,subs=4.4e+7
 ,MM=10000,catal=0.051,tun=2.4,std=8e+7 ,nrepeat=1000,jump=10
 ,burning=0,MM_m=1,MM_v=1e+10)
}
