#' Electronic Health Record (EHR) Data Processing and Analysis Tool
#'
#' The `EHR` package provides modules to perform diverse medication-related
#' studies using data from EHR databases.
#'
#' Package functionality:
#' \itemize{
#' \item Process and analyze Electronic Health Record (EHR) data.
#'
#' \item Implement modules to perform diverse medication-related studies using
#' data from EHR databases. Especially, the package includes modules to perform
#' pharmacokinetic/pharmacodynamic (PK/PD) analyses using EHRs, as outlined in
#' Choi et al. (2020).
#'
#' \item Implement three statistical methods for Phenome Wide Association Study
#' (PheWAS). Contingency tables for many binary outcomes (e.g., phenotypes) and
#' a binary covariate (e.g., drug exposure) can be efficiently generated by
#' \code{\link{zeroOneTable}}, and three commonly used statistical methods to
#' analyze data for PheWAS are implement by \code{\link{analysisPheWAS}}.
#' }
#'
#' @docType package
#'
#' @references
#' \enumerate{
#' \item Development of a system for postmarketing population pharmacokinetic
#' and pharmacodynamic studies using real-world data from electronic health
#' records.\cr
#' Choi L, Beck C, McNeer E, Weeks HL, Williams ML, James NT, Niu X,
#' Abou-Khalil BW, Birdwell KA, Roden DM, Stein CM, Bejan CA, Denny JC,
#' Van Driest SL.\cr
#' Clin Pharmacol Ther. 2020 Apr;107(4):934-943. doi: 10.1002/cpt.1787.
#'
#' \item Evaluating statistical approaches to leverage large clinical datasets
#' for uncovering therapeutic and adverse medication effects.\cr
#' Choi L, Carroll RJ, Beck C, Mosley JD, Roden DM, Denny JC, Van Driest SL.\cr
#' Bioinformatics. 2018 Sep 1;34(17):2988-2996. doi: 10.1093/bioinformatics/bty306.
#' }
#'
#' @importFrom utils data getFromNamespace head read.csv write.csv
#' @importFrom methods as
#' @import stats
#' @import data.table
#'
#' @keywords EHR process PheWAS
"_PACKAGE"

.onLoad <- function(libname, pkgname) {
  myopts <- list(
    ehr.dist_method = 'minEntEnd',
    ehr.na_penalty = 32,
    ehr.neg_penalty = 0.5,
    ehr.greedy_threshold = 1e8
  )
  options(myopts)
  invisible()
}
