% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCIs.R
\name{ciCalculations}
\alias{ciCalculations}
\title{ciCalculations}
\usage{
ciCalculations(eList, startSeed = 494817, verbose = TRUE, ...)
}
\arguments{
\item{eList}{named list with at least the Daily, Sample, and INFO dataframes. Created from the EGRET package, after running \code{\link[EGRET]{modelEstimation}}.}

\item{startSeed}{setSeed value. Defaults to 494817. This is used to make repeatable output.}

\item{verbose}{logical specifying whether or not to display progress message}

\item{\dots}{optionally include nBoot, blockLength, or widthCI}
}
\description{
Interactive function to calculate WRTDS confidence bands
}
\examples{
library(EGRET)
eList <- Choptank_eList
\dontrun{
CIAnnualResults <- ciCalculations(eList)

seriesOut_2 <- runSeries(eList, windowSide = 7)
CIAnnualResults <- ciCalculations(seriesOut_2, 
                     nBoot = 10,
                     blockLength = 200,
                     widthCI = 90)
                     
 plotConcHistBoot(seriesOut_2, CIAnnualResults)

}
}
