% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readNWISDaily.r
\name{readNWISDaily}
\alias{readNWISDaily}
\title{Import NWIS Daily Data for EGRET analysis}
\usage{
readNWISDaily(siteNumber, parameterCd = "00060", startDate = "",
  endDate = "", verbose = TRUE, interactive = NULL, convert = TRUE)
}
\arguments{
\item{siteNumber}{character USGS site number.  This is usually an 8 digit number}

\item{parameterCd}{character USGS parameter code.  This is usually an 5 digit number.}

\item{startDate}{character starting date for data retrieval in the form YYYY-MM-DD.}

\item{endDate}{character ending date for data retrieval in the form YYYY-MM-DD.}

\item{verbose}{logical specifying whether or not to display progress message}

\item{interactive}{logical deprecated. Use 'verbose' instead}

\item{convert}{logical Option to include a conversion from cfs to cms (35.314667). The default is TRUE, 
which is appropriate for using NWIS data in the EGRET package.  Set this to FALSE to not include the conversion. If the parameter code is not 00060 (NWIS discharge),
there is no conversion applied.}
}
\value{
A data frame 'Daily' with the following columns:
\tabular{lll}{
Name \tab Type \tab Description \cr
Date \tab Date \tab Date \cr
Q \tab numeric \tab Discharge in m^3/s\cr
Julian \tab integer \tab Number of days since Jan. 1, 1850\cr
Month \tab integer \tab Month of the year [1-12] \cr 
Day \tab integer \tab Day of the year [1-366] \cr
DecYear \tab numeric \tab Decimal year \cr
MonthSeq \tab integer \tab Number of months since January 1, 1850 \cr
Qualifier \tab character \tab Qualifying code \cr
i \tab integer \tab Index of days, starting with 1 \cr
LogQ \tab numeric \tab Natural logarithm of Q  \cr
Q7 \tab numeric \tab 7 day running average of Q \cr
Q30 \tab numeric \tab 30 day running average of Q \cr
}
}
\description{
Imports daily data from NWIS web service. This function gets the data from here: \url{https://waterservices.usgs.gov/}
}
\examples{
\donttest{

Daily <- readNWISDaily('01594440','00060', '1985-01-01', '1985-03-31')
DailySuspSediment <- readNWISDaily('01594440','80154', '1985-01-01', '1985-03-31',convert=FALSE)
}
}
\seealso{
\code{\link[dataRetrieval]{readNWISdv}}, \code{\link{populateDaily}}
}
\keyword{USGS}
\keyword{WRTDS}
\keyword{data}
\keyword{import}
