% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tableFlowChange.R
\name{tableFlowChange}
\alias{tableFlowChange}
\title{Prints table of change metrics for a given streamflow statistic}
\usage{
tableFlowChange(eList, istat, qUnit = 1, runoff = FALSE, yearPoints = NA)
}
\arguments{
\item{eList}{named list with at least Daily and INFO dataframes}

\item{istat}{A numeric value for the flow statistic to be graphed (possible values are 1 through 8)}

\item{qUnit}{object of qUnit class \code{\link{printqUnitCheatSheet}}, or numeric represented the short code, or character representing the descriptive name.}

\item{runoff}{logical variable, if TRUE the streamflow data are converted to runoff values in mm/day}

\item{yearPoints}{A vector of numeric values, specifying the years at which change metrics are to be calculated, default is NA (which allows the function to set these automatically), yearPoints must be in ascending order}
}
\description{
Part of the flowHistory system.
The index of the flow statistics is istat.  These statistics are:
(1) 1-day minimum, (2) 7-day minimum, (3) 30-day minimum, (4) median
(5) mean, (6) 30-day maximum, (7) 7-day maximum, and (8) 1-day maximum.
A dataframe is returned, as well as a printout in the R console.
}
\examples{
eList <- Choptank_eList
tableFlowChange(eList, istat=5,yearPoints=c(2001,2005,2009))
df <- tableFlowChange(eList, istat=5,yearPoints=c(2001,2005,2009))
}
\keyword{statistics}
\keyword{streamflow}

