% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/modelEstimation.R
\name{flexFN}
\alias{flexFN}
\title{Flexible Flow Normalization}
\usage{
flexFN(eList, nSegments, segStart, segEnd, dStart, dEnd)
}
\arguments{
\item{eList}{named list with at least the Daily, Sample, and INFO dataframes}

\item{nSegments}{integer number of flow normalized segments to create}

\item{segStart}{integer vector of start years (water) for each FN conc/flux segment}

\item{segEnd}{integer vector of end years (water) for each FN conc/flux segment}

\item{dStart}{Date vector of start days for each flow segment}

\item{dEnd}{Date vector of end days for each flow segment}
}
\description{
Flexible Flow Normalization
}
\examples{
eList <- Choptank_eList
eList <- setUpEstimation(eList)
nSegments <- 2
segStart <- c(1985,2000)
segEnd <- c(2001,2010)
dStart <- as.Date(c("1988-10-01","2002-05-15"))
dEnd <- as.Date(c("1998-09-30","2009-09-30"))
eList <- flexFN(eList,nSegments,segStart,segEnd,dStart,dEnd)
plotFluxHist(eList)
}

