% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/boxConcMonth.R
\name{boxConcMonth}
\alias{boxConcMonth}
\title{Box plot of the water quality data by month}
\usage{
boxConcMonth(eList, printTitle = TRUE, cex = 0.8, cex.axis = 1.1,
  cex.main = 1.1, las = 1, logScale = FALSE, tcl = 0.5,
  tinyPlot = FALSE, customPar = FALSE, showYLabels = TRUE,
  showXLabels = TRUE, showXAxis = TRUE, showYAxis = TRUE, ...)
}
\arguments{
\item{eList}{named list with at least the Sample and INFO dataframes}

\item{printTitle}{logical variable if TRUE title is printed, if FALSE not printed (this is best for a multi-plot figure)}

\item{cex}{numerical value giving the amount by which plotting symbols should be magnified}

\item{cex.axis}{magnification to be used for axis annotation relative to the current setting of cex}

\item{cex.main}{magnification to be used for main titles relative to the current setting of cex}

\item{las}{numeric in {0,1,2,3}; the style of axis labels, see ?par}

\item{logScale}{logical if TRUE y plotted in log axis}

\item{tcl}{number defaults to 0.5, specifies length of tick marks as fraction of height of a line of text}

\item{tinyPlot}{logical variable, if TRUE plot is designed to be plotted small as part of a multi-plot figure, default is FALSE.}

\item{customPar}{logical defaults to FALSE. If TRUE, par() should be set by user before calling this function}

\item{showYLabels}{logical defaults to TRUE. If FALSE, the y axis label is not plotted}

\item{showXLabels}{logical defaults to TRUE. If FALSE, the x axis label is not plotted}

\item{showXAxis}{logical defaults to TRUE. If FALSE, the x axis is not plotted}

\item{showYAxis}{logical defaults to TRUE. If FALSE, the y axis is not plotted}

\item{\dots}{arbitrary graphical parameters that will be passed to genericEGRETDotPlot function (see ?par for options)}
}
\description{
Data come from named list, which contains a Sample dataframe with the sample data,
and an INFO dataframe with metadata.

 Although there are a lot of optional arguments to this function, most are set to a logical default.
}
\examples{
eList <- Choptank_eList
# Water year:
boxConcMonth(eList)
# Graphs consisting of Jun-Aug
eList <- setPA(eList, paStart=6,paLong=3)
boxConcMonth(eList)
}
\seealso{
\code{\link[graphics]{boxplot}}
}
\keyword{graphics}
\keyword{statistics}
\keyword{water-quality}

