% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/readMetaData.r
\name{INFOdataframe}
\alias{INFOdataframe}
\alias{readNWISInfo}
\alias{readUserInfo}
\alias{readWQPInfo}
\title{Import metadata to create INFO data frame}
\usage{
readNWISInfo(siteNumber, parameterCd, interactive = TRUE)

readWQPInfo(siteNumber, parameterCd, interactive = TRUE)

readUserInfo(filePath, fileName, hasHeader = TRUE, separator = ",",
  interactive = TRUE)
}
\arguments{
\item{siteNumber}{character site number.  For \code{readNWISInfo}, this is usually an 8 digit number,
for \code{readWQPInfo}, it is usually a longer code. For instance, a USGS site number in the Water Quality Portal
would be in the form `USGS-XXXXXXXX`. If the siteNumber is left blank (an empty string), the interactive
option allows users to enter required information by hand, otherwise those fields are left blank.}

\item{parameterCd}{character USGS parameter code (a 5 digit number) or characteristic name (if using \code{readWQPInfo}). If the
parameterCd is left blank (an empty string), the interactive
option allows users to enter required information by hand, otherwise those fields are left blank.}

\item{interactive}{logical Option for interactive mode.  If true, there is user interaction for error handling and data checks.}

\item{filePath}{character specifying the path to the file (used in \code{readUserInfo})}

\item{fileName}{character name of file to open (used in \code{readUserInfo})}

\item{hasHeader}{logical true if the first row of data is the column headers (used in \code{readUserInfo})}

\item{separator}{character that separates data cells (used in \code{readUserInfo})}
}
\value{
INFO data frame. Any metadata can be stored in INFO. However, there are 8 columns that EGRET uses by name in some functions:

\tabular{lll}{
Required column \tab Used in function \tab Description \cr
param.units*** \tab All concentration plotting functions \tab The units as listed in this field are used
to create the concentration axis labels \cr
shortName \tab All plotting functions \tab Station short name, used to label plots \cr
paramShortName \tab All plotting functions \tab Parameter short name, used to label plots \cr
drainSqKm \tab \code{plotFlowSingle}, \code{printSeries} \tab Calculate runoff\cr
constitAbbrev \tab \code{saveResults} \tab Parameter abbrieviation, used to auto-name workspace\cr
staAbbrev \tab \code{saveResults} \tab Station abbrieviation, used to auto-name workspace\cr
paStart \tab Most EGRET functions \tab Starting month of period of analysis. Defaults to 10\cr
paLong \tab Most EGRET functions \tab Length in number of months of period of analysis. Defaults to 12\cr
}
*** Additionally, EGRET assumes that all concentrations are saved in mg/l. If some variation of
'mg/l' is not found in INFO$param.units, functions that calculate flux will issue a warning. This
is because the conversion from mg/l to the user-specified flux unit (e.g., kg/day) uses hard-coded conversion factors.
}
\description{
Populates INFO data frame from either NWIS (\code{readNWISInfo}),
Water Quality Portal (\code{readWQPInfo}), or user-supplied files (\code{readUserInfo}).
}
\examples{
# These examples require an internet connection to run
# Automatically gets information about site 05114000 and temperature
\dontrun{
INFO <- readNWISInfo('05114000','00010')
}
# These examples require an internet connection to run
# Automatically gets information about site 01594440 and temperature, no interaction with user
nameToUse <- 'Specific conductance'
pcodeToUse <- '00095'
\dontrun{
INFO <- readWQPInfo('USGS-04024315',pcodeToUse)

INFO2 <- readWQPInfo('WIDNR_WQX-10032762',nameToUse)
# To adjust the label names:
INFO$shortName <- "Little"
INFO$paramShortName <- "SC"
}
filePath <- system.file("extdata", package="EGRET")
filePath <- paste(filePath,"/",sep="")
fileName <- 'infoTest.csv'
INFO <- readUserInfo(filePath,fileName, separator=",",interactive=FALSE)
}
\seealso{
\code{\link[dataRetrieval]{readNWISsite}}, \code{\link[dataRetrieval]{readNWISpCode}}

\code{\link[dataRetrieval]{whatWQPsites}}
}
\keyword{USGS}
\keyword{data}
\keyword{import}
\keyword{service}
\keyword{web}

