% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/generalAxis.R
\name{generalAxis}
\alias{generalAxis}
\title{Axis generation for log discharge}
\usage{
generalAxis(x, maxVal, minVal, units = NA, logScale = FALSE,
  tinyPlot = FALSE, padPercent = 5, concentration = TRUE)
}
\arguments{
\item{x}{vector to create scale about}

\item{maxVal}{number maximum value on returned scale}

\item{minVal}{number minimum value on returned scale}

\item{units}{character concentration units. Typically found in INFO$param.units.}

\item{logScale}{logical whether or not to return a log scale}

\item{tinyPlot}{logical}

\item{padPercent}{number used to pad the max and min if not specified}

\item{concentration}{logical if concentration=TRUE, labels returned as concentration units, otherwise flux units.}
}
\description{
Discharge axis tick generation
}
\examples{
eList <- Choptank_eList
Daily <- getDaily(eList)
INFO <- getInfo(eList)
x <- Daily$Q
max <- max(x)
min <- 0
units <- INFO$param.units
generalAxis(x, max, min, units)
min <- min(x)
generalAxis(x, max, min, units, log=TRUE)
}
\keyword{graphics}
\keyword{statistics}
\keyword{water-quality}

