% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Embed.R
\name{Embed}
\alias{Embed}
\title{Time-delay Embedding}
\usage{
Embed(x, E, tau)
}
\arguments{
\item{x}{Vector.
An observed time series to be reorganized into a time-delayed embedded matrix.}

\item{E}{Integer.
Number of embedded dimensions or the number of observations to be used. For example,
an \code{"E = 5"} will generate a matrix with five columns, meaning that five consecutive observations are used to create each row of the embedded matrix.}

\item{tau}{Integer.
Number of observations to offset successive embeddings. A tau of one uses adjacent observations.
Default is \code{"tau = 1"}.}
}
\value{
Returns a matrix containing the embedded matrix.
}
\description{
Reorganizes an individual’s observed time
series into an embedded matrix. The embedded matrix is constructed with replicates of an
individual time series that are offset from each other in time. The function requires
two parameters, one that specifies the number of observations to be used (i.e. the number of
embedded dimensions) and the other that specifies the number of observations to offset successive embeddings.
}
\examples{

# A time series with 8 time points
tseries <- 49:56
embed.tseries <- Embed(tseries, E = 4, tau = 1)


}
\references{
Deboeck, P. R., Montpetit, M. A., Bergeman, C. S., & Boker, S. M. (2009)
Using derivative estimates to describe intraindividual variability at multiple time scales.
\emph{Psychological Methods}, \emph{14}, 367-386.
}
\author{
Pascal Deboeck <pascal.deboeck at psych.utah.edu>
}
