% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.dynEGA.Groups.R
\name{plot.dynEGA.Groups}
\alias{plot.dynEGA.Groups}
\title{Plot method for \code{\link[EGAnet]{dynEGA}}objects (Level: Group)}
\usage{
\method{plot}{dynEGA.Groups}(x, ncol, nrow, title = "", vsize = 6, ...)
}
\arguments{
\item{x}{An \code{\link[EGAnet]{dynEGA}} object (Level: Group)}

\item{ncol}{Number of columns}

\item{nrow}{Number of rows}

\item{title}{Character. Title of the plot}

\item{vsize}{An integer indicating the size of the nodes.
Default vsize = 6}

\item{...}{Arguments passed to \code{\link[qgraph]{qgraph}}}
}
\description{
Plots the \code{\link[EGAnet]{dynEGA}} result using \code{\link[qgraph]{qgraph}}
}
\examples{
\dontrun{
# Estimate dynEGA
dyn.group <- dynEGA(data = sim.dynEGA, n.embed = 5, tau = 1,
delta = 1, id = 21, group = 22, use.derivatives = 1,
level = "group", model = "glasso")

#Summary of dynEGA reults
summary(dyn.group)

# Plot EGA network
plot(dyn.group, vsize = 6, label.prop = 1)
}

}
\seealso{
\code{\link[EGAnet]{dynEGA}} to estimate the number of dimensions in multivariate time series using dynEGA.
}
\author{
Hudson F. Golino <hfg9s at virginia.edu>
}
